IF OBJECT_ID('CG_FND_VERBA_FECHAMENTO_EST_NF_ENT_IT') IS NULL
begin
	CREATE TABLE [dbo].[CG_FND_VERBA_FECHAMENTO_EST_NF_ENT_IT](
		[CD_FND_VERBA_FECHAMENTO] [int] NOT NULL,
		[CD_EMP] [int] NOT NULL,
		[CD_FILIAL] [int] NOT NULL,
		[CD_NF] [int] NOT NULL,
		[CD_PROD] [int] NOT NULL,
		[QT_PROD] [money] NOT NULL,
		[VLR_PROD_VERBA] [money] NOT NULL,
		[VLR_PROD_VERBA_LIMITE] [money] NOT NULL,
		[VLR_PROD_VERBA_MOVIMENTO] [money] NOT NULL,
		[VLR_PROD_VERBA_USADA] [money] NOT NULL,
		CONSTRAINT [PK_CG_FND_VERBA_FECHAMENTO_EST_NF_ENT_IT] PRIMARY KEY CLUSTERED 
	(
		[CD_FND_VERBA_FECHAMENTO] ASC,
		[CD_EMP] ASC,
		[CD_FILIAL] ASC,
		[CD_NF] ASC,
		[CD_PROD] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]

	ALTER TABLE [dbo].[CG_FND_VERBA_FECHAMENTO_EST_NF_ENT_IT] ADD  CONSTRAINT [DF_CG_FND_VERBA_FECHAMENTO_EST_NF_ENT_IT_CD_FND_VERBA_FECHAMENTO]  DEFAULT ((0)) FOR [CD_FND_VERBA_FECHAMENTO]

	ALTER TABLE [dbo].[CG_FND_VERBA_FECHAMENTO_EST_NF_ENT_IT] ADD  CONSTRAINT [DF_CG_FND_VERBA_FECHAMENTO_EST_NF_ENT_IT_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

	ALTER TABLE [dbo].[CG_FND_VERBA_FECHAMENTO_EST_NF_ENT_IT] ADD  CONSTRAINT [DF_CG_FND_VERBA_FECHAMENTO_EST_NF_ENT_IT_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

	ALTER TABLE [dbo].[CG_FND_VERBA_FECHAMENTO_EST_NF_ENT_IT] ADD  CONSTRAINT [DF_Table_1_CD_VD]  DEFAULT ((0)) FOR [CD_NF]

	ALTER TABLE [dbo].[CG_FND_VERBA_FECHAMENTO_EST_NF_ENT_IT] ADD  CONSTRAINT [DF_Table_1_CD_IT]  DEFAULT ((0)) FOR [CD_PROD]

	ALTER TABLE [dbo].[CG_FND_VERBA_FECHAMENTO_EST_NF_ENT_IT] ADD  CONSTRAINT [DF_CG_FND_VERBA_FECHAMENTO_EST_NF_ENT_IT_QT_PROD]  DEFAULT ((0)) FOR [QT_PROD]

	ALTER TABLE [dbo].[CG_FND_VERBA_FECHAMENTO_EST_NF_ENT_IT] ADD  CONSTRAINT [DF_CG_FND_VERBA_FECHAMENTO_EST_NF_ENT_IT_VLR_PROD_VERBA]  DEFAULT ((0)) FOR [VLR_PROD_VERBA]

	ALTER TABLE [dbo].[CG_FND_VERBA_FECHAMENTO_EST_NF_ENT_IT] ADD  CONSTRAINT [DF_CG_FND_VERBA_FECHAMENTO_EST_NF_ENT_IT_VLR_PROD_VERBA_LIMITE]  DEFAULT ((0)) FOR [VLR_PROD_VERBA_LIMITE]

	ALTER TABLE [dbo].[CG_FND_VERBA_FECHAMENTO_EST_NF_ENT_IT] ADD  CONSTRAINT [DF_CG_FND_VERBA_FECHAMENTO_EST_NF_ENT_IT_VLR_PROD_VERBA_MOVIMENTO]  DEFAULT ((0)) FOR [VLR_PROD_VERBA_MOVIMENTO]

	ALTER TABLE [dbo].[CG_FND_VERBA_FECHAMENTO_EST_NF_ENT_IT] ADD  CONSTRAINT [DF_CG_FND_VERBA_FECHAMENTO_EST_NF_ENT_IT_VLR_PROD_VERBA_USADA]  DEFAULT ((0)) FOR [VLR_PROD_VERBA_USADA]

	ALTER TABLE [dbo].[CG_FND_VERBA_FECHAMENTO_EST_NF_ENT_IT]  WITH CHECK ADD  CONSTRAINT [FK_CG_FND_VERBA_FECHAMENTO_EST_NF_ENT_IT_CG_FND_VERBA_FECHAMENTO] FOREIGN KEY([CD_FND_VERBA_FECHAMENTO])
	REFERENCES [dbo].[CG_FND_VERBA_FECHAMENTO] ([CD_FND_VERBA_FECHAMENTO])

	ALTER TABLE [dbo].[CG_FND_VERBA_FECHAMENTO_EST_NF_ENT_IT] CHECK CONSTRAINT [FK_CG_FND_VERBA_FECHAMENTO_EST_NF_ENT_IT_CG_FND_VERBA_FECHAMENTO]

	ALTER TABLE [dbo].[CG_FND_VERBA_FECHAMENTO_EST_NF_ENT_IT]  WITH CHECK ADD  CONSTRAINT [FK_CG_FND_VERBA_FECHAMENTO_EST_NF_ENT_IT_EST_NF_ENT_IT] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_NF], [CD_PROD])
	REFERENCES [dbo].[EST_NF_ENT_IT] ([CD_EMP], [CD_FILIAL], [CD_NF], [CD_PROD])

	ALTER TABLE [dbo].[CG_FND_VERBA_FECHAMENTO_EST_NF_ENT_IT] CHECK CONSTRAINT [FK_CG_FND_VERBA_FECHAMENTO_EST_NF_ENT_IT_EST_NF_ENT_IT]
end

